export default function AboutPage() {
  return (
    <div className="min-h-screen bg-gray-50">
      <div className="container py-20">
        <h1 className="text-5xl font-bold text-center mb-12 text-gray-900">
          About Nine Three Merch
        </h1>
        
        <div className="max-w-4xl mx-auto">
          <div className="card mb-8">
            <h2 className="text-2xl font-bold mb-4 text-red-600">Our Story</h2>
            <p className="text-gray-600 mb-4">
              Nine Three Merch LLC was founded in July 2025 with a simple mission: to provide exceptional auto detailing services and high-quality merchandise to car enthusiasts and everyday drivers alike. Our name represents our commitment to going above and beyond - Nine Three, always giving more than expected.
            </p>
            <p className="text-gray-600 mb-4">
              Founded by Mary Ann Hope Ramirez, Nine Three Merch started as a passion project that quickly grew into a thriving business serving communities in both Texas and Mississippi. Our dedication to quality and customer satisfaction has made us a trusted name in automotive care.
            </p>
          </div>
          
          <div className="card mb-8">
            <h2 className="text-2xl font-bold mb-4 text-red-600">Our Mission</h2>
            <p className="text-gray-600">
              To deliver premium auto detailing services that exceed expectations while offering exclusive merchandise that represents the automotive lifestyle. We believe every vehicle deserves to look its best, and every customer deserves exceptional service.
            </p>
          </div>
          
          <div className="grid grid-cols-1 md:grid-cols-2 gap-8 mb-8">
            <div className="card">
              <h3 className="text-xl font-bold mb-3 text-gray-900">What Sets Us Apart</h3>
              <ul className="space-y-2 text-gray-600">
                <li className="flex items-start">
                  <span className="text-green-500 mr-2">✓</span>
                  Professional-grade products and equipment
                </li>
                <li className="flex items-start">
                  <span className="text-green-500 mr-2">✓</span>
                  Attention to every detail
                </li>
                <li className="flex items-start">
                  <span className="text-green-500 mr-2">✓</span>
                  Competitive pricing
                </li>
                <li className="flex items-start">
                  <span className="text-green-500 mr-2">✓</span>
                  Customer satisfaction guarantee
                </li>
              </ul>
            </div>
            
            <div className="card">
              <h3 className="text-xl font-bold mb-3 text-gray-900">Company Details</h3>
              <dl className="space-y-2 text-gray-600">
                <div>
                  <dt className="font-semibold">Legal Name:</dt>
                  <dd>Nine Three Merch LLC</dd>
                </div>
                <div>
                  <dt className="font-semibold">EIN:</dt>
                  <dd>39-3412571</dd>
                </div>
                <div>
                  <dt className="font-semibold">Founded:</dt>
                  <dd>July 25, 2025</dd>
                </div>
                <div>
                  <dt className="font-semibold">State of Formation:</dt>
                  <dd>Mississippi</dd>
                </div>
              </dl>
            </div>
          </div>
        </div>
      </div>
    </div>
  )
}
